/*********************************************************************
 *
 *                  Headers for TCPIP Demo App
 *
 *********************************************************************
 * FileName:        MainDemo.h
 * Dependencies:    Compiler.h
 * Processor:       PIC18, PIC24F, PIC24H, dsPIC30F, dsPIC33F, PIC32
 * Compiler:        Microchip C32 v1.05 or higher
 *					Microchip C30 v3.12 or higher
 *					Microchip C18 v3.30 or higher
 *					HI-TECH PICC-18 PRO 9.63PL2 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * Copyright (C) 2002-2010 Microchip Technology Inc.  All rights
 * reserved.
 *
 * Microchip licenses to you the right to use, modify, copy, and
 * distribute:
 * (i)  the Software when embedded on a Microchip microcontroller or
 *      digital signal controller product ("Device") which is
 *      integrated into Licensee's product; or
 * (ii) ONLY the Software driver source files ENC28J60.c, ENC28J60.h,
 *		ENCX24J600.c and ENCX24J600.h ported to a non-Microchip device
 *		used in conjunction with a Microchip ethernet controller for
 *		the sole purpose of interfacing with the ethernet controller.
 *
 * You should refer to the license agreement accompanying this
 * Software for additional information regarding your rights and
 * obligations.
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * MICROCHIP BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 *
 * Author               Date    Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * E. Wood				4/26/08 Copied from MainDemo.c
 ********************************************************************/
#ifndef _MAINDEMO_H
#define _MAINDEMO_H

#include "TCPIP Stack/TCPIP.h"
//#include "gqueue.h"  bob 2-4-2013
#define BAUD_RATE       (19200)		// bps

#if !defined(THIS_IS_STACK_APPLICATION)
	extern BYTE AN0String[8];
#endif

void DoUARTConfig(void);

#if defined(SPIFLASH_CS_TRIS)
	void SaveAppConfig(void);
#else
	#define SaveAppConfig()
#endif

enum TimeZones{
Newfoundland = 1, // Canada GMT - 3:30
Atlantic,        //Canada  GMT - 4
Eastern,		 //EST, EDT GMT -5 
Central,		 //CST, CDT GMT -6  
Mountain,		 //MST, MDT GMT -7 
Pacific,		 //GNMT -8
Alaska,			 //GMT -9
Hawaii			 //GMT -10} Months;
};

  

// Application-dependent structure used to contain address information

typedef struct __attribute__((__packed__)) 
{
	int		Watt_Load_A;               // areg calculated load
	int		Watt_Load_B;               // breg calculated load
	int		Watt_Load_C;               // creg calculated load	
	double   Accum_A_Reg;				// ACCUMULATED RAW A REG VALUES	
	double   Accum_B_Reg;				// ACCUMULATED RAW B REG VALUES		
	double   Accum_C_Reg;				// ACCUMULATED RAW C REG VALUES
	double   Accum_Total_Watt_Hour;		// accumulated watt hour 
	unsigned long   UTC_time;			//current utc time
	char BillDay[2];
	int TimeZone;
	BOOL	DST;						//True = DST false Standard time
	char logFileName[7];
	int		CRC;						//16 bit CRC


} POWER_READINGS;



// Application-dependent structure used to contain address information
typedef struct __attribute__((__packed__)) 
{
	
	
	char        CR;
	char		Watt_Load_A[7];               // areg calculated load
	char		comma1;
	char		Watt_Load_B[7];               // breg calculated load
	char		comma2;
	char		Watt_Load_C[7];               // creg calculated load
	char		comma3;
	char   		Accum_A_Total_Watt_Hour[12];				// ACCUMULATED RAW A REG VALUES
	char		comma4;	
	char   		Accum_B_Total_Watt_Hour[12];				// ACCUMULATED RAW B REG VALUES	
	char		comma5;	
	char   		Accum_C_Total_Watt_Hour[12];				// ACCUMULATED RAW C REG VALUES	
	char		comma6;
	char   		Accum_Total_Watt_Hour[12];		// accumulated watt hour 
	char		comma7;
	char   		Meter_Reading[11];   // starting meter reading
	char		comma10;				
	char    	date[10];
	char		comma8;
	char		time[8];
	char		comma9;
	int			CRC;							// 16 BIT CRC
	
} CSV_STRUCTURE;  //used to wrire to thumb drive


typedef struct __attribute__((__packed__)) 
{
	char		GAIN[6];
	char		CR29;
	char		LF29;
	char		AVARG[6];               	
	char		CR26;
	char		LF26;
	char		BVARG[6];               	
	char		CR27;
	char		LF27;
	char		CVARG[6];               	
	char		CR28;
	char		LF28;
	char		AVRMSOS[6];               	
	char		CR1;
	char		LF1;
	char		BVRMSOS[6];               	
	char		CR2;
	char		LF2;
	char		CVRMSOS[6];               	
	char		CR3;
	char		LF3;
	char		AIRMSOS[6];               	// AIRMS OFF SET REGISTER
	char		CR4;
	char		LF4;
	char		BIRMSOS[6];               	// BIRMS OFF SET REGISTER
	char		CR5;
	char		LF5;
	char		CIRMSOS[6];               	// CIRMS OFF SET REGISTER
	char		CR6;
	char		LF6;
	char		AWG[6];               		// AWG GAIN REGISTER
	char		CR7;
	char		LF7;
	char		BWG[6];               		// AWG GAIN REGISTER
	char		CR8;
	char		LF8;
	char		CWG[6];               		// AWG GAIN REGISTER
	char		CR9;
	char		LF9;
	char		AVAG[6];               		// A VOLT AMPERE GAIN REGISTER
	char		CR10;
	char		LF10;	
	char		BVAG[6];               		// B VOLT AMPERE GAIN REGISTER
	char		CR11;
	char		LF11;
	char		CVAG[6];               		// C VOLT AMPERE GAIN REGISTER
	char		CR12;
	char		LF12;
	char		APHCAL[6];               	// A PHASE CALIBRATION REGISTER
	char		CR13;
	char		LF13;
	char		BPHCAL[6];               	// B PHASE CALIBRATION REGISTER
	char		CR14;
	char		LF14;
	char		CPHCAL[6];               	// C PHASE CALIBRATION REGISTER
	char		CR15;
	char		LF15;
	char		AWATTOS[6];               	// A WATT HOUR OFFSET
	char		CR16;
	char		LF16;
	char		BWATTOS[6];               	// B WATT HOUR OFFSET
	char		CR17;
	char		LF17;
	char		CWATTOS[6];               	// B WATT HOUR OFFSET
	char		CR18;
	char		LF18;
	char		WH_LSB[10];					// WH LSB FACTOR
	char		CR19;
	char		LF19;
	char		VA_LSB[10];					// A VOLTAGE LSB FACTOR
	char		CR20;
	char		LF20;
	char		VB_LSB[10];					// B VOLTAGE LSB FACTOR
	char		CR21;
	char		LF21;
	char		VC_LSB[10];					// C VOLTAGE LSB FACTOR
	char		CR22;
	char		LF22;
	char		IA_LSB[10];					// A CURRENT LSB FACTOR
	char		CR23;
	char		LF23;
	char		IB_LSB[10];					// A CURRENT LSB FACTOR
	char		CR24;
	char		LF24;
	char		IC_LSB[10];					// A CURRENT LSB FACTOR
	char		CR25;
	char		LF25;
	int			CRC;						// 16 BIT CRC
		
} CALIBRATION_STRUCTURE;  //used to read/wrire to thumb drive








// Structure defining Google PowerMeter Preferences (configuration options)
typedef struct __attribute__((__packed__))
{
    BYTE auth_token[65];        // The user identification value
    BYTE auth_path[193];        // The data upload path
    DWORD snonce;               // A security nonce
    BYTE pKeyHashes[3][20];     // SHA-1 hashes of potential Google SSL certificaties
    WORD cap_sec_interval;      // Data capture interval (in seconds)
    WORD send_sec_interval;     // Data transmission interval (in seconds)
    BOOL send_status;           // Boolean - indicates whether to send status information
} POWER_METER_PREFERENCES;
void SMTPDemo(void);
void PingDemo(void);
void SNMPTrapDemo(void);
void SNMPV2TrapDemo(void);
// Defines an enumeration that corresponds to our sensors
typedef enum
{
    CM_RESERVED = 0u,       // Triangle wave sample sensor
    CM_RESERVED1,                 // Potentiometer-based sample sensor
    CM_POWER_MONITOR        // the Kunzig Power Meter
} PMCaptureMode;

// Define an enumeration to handle our button-press state machine
typedef enum
{
    SM_IDLE = 0u,
    SM_DEBOUNCE_DOWN,
    SM_RELEASE_WAIT,
    SM_DEBOUNCE_UP
} PMButtonState;

extern POWER_METER_PREFERENCES gPowerMeterPreferences;
extern PMCaptureMode captureMode;
void GenericTCPClient(void);
void GenericTCPServer(void);
void BerkeleyTCPClientDemo(void);
void BerkeleyTCPServerDemo(void);
void BerkeleyUDPClientDemo(void);

// Defines the number of sensors the device is using
// This value is based on the GQ_NUM_QUEUES macro, defined in gqueue.h
#define DEVICE_NUM_SENSORS      GQ_NUM_QUEUES
// Defines the build number
#define APPLICATION_BUILD       0x62

// Defines the reserved block for web pages in non-volatile memory
#define NV_MEM_RESERVE_BLOCK        (MPFS_RESERVE_BLOCK)

// Enumeration for non-volatile memory allocation
typedef enum
{
    identifierOffset = 0,
    appConfigOffset = 1,
    powerMeterPreferencesOffset = sizeof (APP_CONFIG) + 1,
    structureEndOffset = powerMeterPreferencesOffset + sizeof (POWER_METER_PREFERENCES),
} NV_MEM_STRUCTURE_OFFSETS;
// An actual function defined in MainDemo.c for displaying the current IP 
// address on the UART and/or LCD.
void DisplayIPValue(IP_ADDR IPVal);


#endif // _MAINDEMO_H
